<?php
// +----------------------------------------------------------------------
// | swoole服务端
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

require_once 'function.php';

// 授权html
function get_html($html) {
    return '<!doctype html>
    <html>
    <head>
        <meta content="webkit" name="renderer" />
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <title>Swoole+Jquery实现扫码登录</title>
        <style>
            body{height:100%;background:#edf0f5;font-family:"Microsoft YaHei",Arial,Helvetica,sans-serif;color:#89a;font-size:14px}
            .logon{margin:0 auto;position:relative;top:8%}
            .logon-frame{margin:30px auto;border:1px solid #e5e9ed;background:#fff;padding:35px 40px;border-radius:3px}
            .logon .logon-nopadding{padding:0}
            .logon .qr-code{padding:40px}
            img{vertical-align:middle}
            .logon .qr-code img{display:block;width:240px;padding:10px;border:1px solid #e5e9ed;background:#f8f9fb;margin:0 auto 20px;border-radius:3px}
            .logon .qr-code p{text-align:center;margin-bottom:0;font-size:16px;color:#89a}
            p{margin:0 0 10px}
            .logon .qr-ico{background:url(images/sprites_icon.png) no-repeat 0 -525px;width:14px;height:14px;display:inline-block;margin-right:8px}
            .b-agreement{font-size:12px;line-height:12px;text-align:center;padding-top:10px;display:block}
            .b-agreement a{color:#3ea2ff}
        </style>
    </head>
    
    <body>
        <div class="logon">
            <div class="logon-frame logon-nopadding">
                <div class="qr-code">
                    '.$html.'
                </div>
            </div>
        </div>
       
    </body>
    </html>';
}

$ws = new Swoole\WebSocket\Server('0.0.0.0', 9502);

// 用Sw的Table实现一个小队列，用于记录客户端标识，这里只用作demo
// 正常这个Lists是需要有自动过期时间的，防止被无限刷，可以用redis做存储
$table = new Swoole\Table(1024);
$table->column('fd', Swoole\Table::TYPE_INT, 12);
$table->create();

$ws->table = $table;

//监听WebSocket连接打开事件
$ws->on('open', function ($ws, $request) {
    // 写入队列标识
    $ws->table->set($request->get['rand_str'], [
        'fd' => $request->fd
    ]);
});

//监听WebSocket消息事件
$ws->on('message', function ($ws, $frame) {
    // 输出下登录成功的内容
    echo "Message: {$frame->data}\n";
});

//监听WebSocket连接关闭事件
$ws->on('close', function ($ws, $fd) {
    // 清除无效的队列
    $list = $ws->table->get();
    foreach ($list as $k=>$v) {
        if ($v['fd'] == $fd) {
            $redis->delete($k);
            break;
        }
    }
});

// 监听http请求
$ws->on('request', function ($request, $response) use ($ws){
    # 如果你是get的，就改成get，可以用dump看看$request
    $param = $request->get;

    // 授权页面
    if ($param['route'] == 'login') {
        $fd = $ws->table->get($param['fd']);
        if ($fd == false) {
            $html = get_html('<p>授权失败</p>');
        } else {
            # 输出响应
            $return = json_encode(array(
                'code' => '01',
                'msg' => '已扫码，请在手机端确认登录！'
            ));
            $ws->push($fd['fd'], $return);
            $html = get_html('<p><span class="qr-ico"></span><a href="http://'.get_ip().':9502?route=Oauth&fd='.$param['fd'].'">点击确认授权</a></p>');
        }
        // 输出页面内容
        $response->end($html);
    // 授权确认
    } else if ($param['route'] == 'Oauth') {
        $fd = $ws->table->get($param['fd']);
        if ($fd == false) {
            $html = get_html('<p>授权失败</p>');
        } else {
            # 输出响应
            $return = json_encode(array(
                'code' => '02',
                'msg' => '已确认授权！'
            ));
            $ws->push($fd['fd'], $return);
            $html = get_html('<p><span class="qr-ico"></span><a>点击离开该页面</a></p>');
        }
        // 输出页面内容
        $response->end($html);
    }
    
});
$ws->start();