<?php
require_once 'function.php';
?>
<!doctype html>
<html>
<head>
    <meta content="webkit" name="renderer" />
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <title>Swoole+Jquery实现扫码登录</title>
    <style>
        body{height:100%;background:#edf0f5;font-family:"Microsoft YaHei",Arial,Helvetica,sans-serif;color:#89a;font-size:14px}
        .logon{width:530px;margin:0 auto;position:relative;top:8%}
        .logon-frame{width:440px;margin:30px auto;border:1px solid #e5e9ed;background:#fff;padding:35px 40px;border-radius:3px}
        .logon .logon-nopadding{padding:0}
        .logon .qr-code{padding:40px}
        img{vertical-align:middle}
        .logon .qr-code img{display:block;width:240px;padding:10px;border:1px solid #e5e9ed;background:#f8f9fb;margin:0 auto 20px;border-radius:3px}
        .logon .qr-code p{text-align:center;margin-bottom:0;font-size:16px;color:#89a}
        p{margin:0 0 10px}
        .logon .qr-ico{background:url(images/sprites_icon.png) no-repeat 0 -525px;width:14px;height:14px;display:inline-block;margin-right:8px}
        .b-agreement{font-size:12px;line-height:12px;text-align:center;padding-top:10px;display:block}
        .b-agreement a{color:#3ea2ff}
    </style>
</head>

<body>
    <div class="logon">
        <div class="logon-frame logon-nopadding">
            <div class="qr-code">

                <img src="images/qr-code.png" id="qrcode" style="display:block;cursor: pointer;" title="点击刷新">

                <img src="images/loading2.gif" id="load" width="32" height="32" style="height:42px; width:42px;display:none" />

                <div id="msg" class="b-agreement" style="display:none;margin-bottom: 20px;"><a></a></div>

                <p><span class="qr-ico"></span>使用手机扫码即可登录/注册</p>
                <div class="b-agreement">扫码即表示已阅读并接受<a href="javascript:;" target="_blank">《用户协议》</a></div>
            </div>
        </div>
    </div>
   
</body>
</html>
<script src="https://blog.junphp.com/public/js/jquery.min.js"></script>

<script>
// 当前客户端标识符
var fd = 'ABC123';
// websocket地址
var wsServer = 'ws://<?php echo get_ip();?>:9502?rand_str='+fd;
// 实例
var websocket;
// ①开启WebSocket
try {
    websocket = new WebSocket(wsServer);
    init();
} catch(e) {
    $('#msg').show();
    $('#msg a').html('websocket链接失败！');
}
// ②初始化WebSocket
function init() {
    // 接收Socket断开时的消息通知
    websocket.onclose = function(e) {
        $('#msg').show();
        $('#msg a').html('Socket断开了...');
    };
    // 接收Socket连接失败时的异常通知
    websocket.onerror = function(e){
        $('#msg').show();
        $('#msg a').html('Socket断开了...');
    };
    // 连接成功
    websocket.onopen = function (e) {
        $('#msg').show();
        $('#msg a').html('握手成功，您可以开始扫码了...');
    };
    // 接收服务端广播的消息通知
    websocket.onmessage = function(evt){
        var obj = JSON.parse(evt.data); 
        if (obj.code == '01') {
            $('#msg').show();
            $('#msg a').html(obj.msg);
        } else if (obj.code == '02') {
            $('#msg').show();
            $('#msg a').html(obj.msg);
            var data = {
                'code':'02',
                'msg':'客户端已收到授权通过推送！'
            };
            // 前端发送json前，必须先转义成字符串
            data = JSON.stringify(data);
            websocket.send(data);
        } 
    };
}

// 刷新二维码
get_qrcode();
function get_qrcode(){
    $('#load').show();
    $('#qrcode').hide();
    $.ajax({
        url : 'qrcode.php',
        type : 'post',
        async: false,
        data : {
            fd:fd
        },
        success : function(src){
            $('#qrcode').attr('src', src);
            $('#load').hide();
            $('#qrcode').show();
        }
    });
}
// 点击刷新二维码
$('#qrcode').click(function(){
    get_qrcode();
    $('#msg').hide();
})
</script>